##############################################################################
#
# PROJECT:      R-BASIC CNC machine control library
#               Local Makefile
# FILE:         LOCAL.MK
#
# AUTHOR:       (c) 2019, Ulrich Cordes
#
##############################################################################


# XGOCFLAGS are passed to the GOC-Pre-Prozessor
# Libraries requires the -L flag
XGOCFLAGS = -L sdklib



# Do not Create any EC version
# NO_EC = 1
NO_EC = 1


# XCCOMFLAGS are passed to the C-Compiler

# Allgemein verwendbare XCCOMFLAGS
# -d     reduces the size of the dgroup by merging duplicate strings.
# -dc 	 reduces the size of the dgroup by compiling strings to the
#	 code segment (not to the dgroup)
XCCOMFLAGS +=  -d -dc


# XCCOMFLAGS that specify the CPU you have
# look here, if your compiler has problems
# -1     186               -3    386 (may cause problems with swat)
# -2     286 		   -1- -2- -3-   8086
XCCOMFLAGS += -3


# XCCOMFLAGS needed for Libraries
# -WDE   compile for SS != DS, only for Libraries
#	 If this flag si set, the library can access its own global
#	 variables directly (DS is set correctly). Without this flag,
#        you need the sequence PUSH DS; GeodeLoadDGroup(); POP DS
# -w-stu turn off "undefined structure" warning
# -Z     Optimize use of registers
# -O     Optimize jump's
XCCOMFLAGS += -WDE -w-stu -Z -O



# LINKFLAGS are passed to the GLUE-Linker

# Create a Copyrigth-notice
LINKFLAGS += -N (c)\202019,\20Ulrich\20Cordes

#include <$(SYSMAKEFILE)>

